
IF OBJECT_ID('TRG_RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF_ENVIO_PENDENCIA') IS NOT NULL
    BEGIN
        DROP TRIGGER TRG_RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF_ENVIO_PENDENCIA;
END;
GO
CREATE TRIGGER TRG_RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF_ENVIO_PENDENCIA ON RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF
FOR INSERT, UPDATE
AS
BEGIN TRY
 IF NOT EXISTS( SELECT 
     i.CD_EMP 
      FROM 
     RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF_ENVIO_PENDENCIA p INNER JOIN  INSERTED i ON
     p.CD_EMP = i.CD_EMP AND
     p.CD_CTR_LOTE  = i.CD_CTR_LOTE AND
     p.CD_FILIAL = i.CD_FILIAL AND
     p.CD_VD = i.CD_VD AND
     p.CD_CTR = i.CD_CTR)
  begin
   INSERT INTO RC_CONC_PDV_CUPOM_NAO_FISCAL_TEF_ENVIO_PENDENCIA
   (CD_EMP,
   CD_CTR_LOTE,
   CD_FILIAL,
   CD_VD,
   CD_CTR,
   FLAG_RESPOSTA)
   SELECT 
    i.CD_EMP,
    i.CD_CTR_LOTE,
    i.CD_FILIAL,
    i.CD_VD,
    i.CD_CTR,
    0
   FROM
    INSERTED i 
  end
END TRY
BEGIN CATCH
 DECLARE @mensagemErro varchar(250);
 DECLARE @severidadeErro int;
 DECLARE @estadoErro  int;
 SELECT @mensagemErro =  ERROR_MESSAGE(), 
  @severidadeErro = ERROR_SEVERITY(), 
  @estadoErro  = ERROR_STATE();
 RAISERROR (@mensagemErro , @severidadeErro , @estadoErro ); 
END CATCH